import pygaze
from pygaze.display import Display
from pygaze.screen import Screen
import pygaze.libtime as timer
import numpy
from psychopy.visual import GratingStim

# Create a new Display instance.
disp = Display()

# Create a new grating stimulus, using PsychoPy.
gabor = GratingStim(pygaze.expdisplay, tex='sin', mask='gauss', \
    sf=0.05, size=200)
# Create a new Screen instance.
gaborscreen = Screen()
# Add the GratingStim to the Screen's stimulus list.
gaborscreen.screen.append(gabor)

# Create some noise using NumPy.
noise = (numpy.random.rand(64, 64) * 2) - 1
# Create a new grating stimulus, using PsychoPy and the noise created before.
noisepatch = GratingStim(pygaze.expdisplay, tex=noise, mask='gauss', \
    size=200)
# Create a new Screen instance.
noisescreen = Screen()
# Add the GratingStim to the Screen's stimulus list.
noisescreen.screen.append(noisepatch)

# Fill the Display with the Gabor screen.
disp.fill(gaborscreen)
# Show the Display on the computer monitor.
disp.show()
# Wait for one second.
timer.pause(1000)

# Fill the Display with the noise screen.
disp.fill(noisescreen)
# Show the Display on the computer monitor.
disp.show()
# Wait for two seconds.
timer.pause(2000)

disp.close()