import os

from constants import *

from pygazeanalyser.edfreader import read_edf
from pygazeanalyser import gazeplotter

from matplotlib.pyplot import close

# Construct the name of the output directory
OUTPUTDIR = os.path.join(DIR, 'output')

# Check if the output directory exists yet
if not os.path.isdir(OUTPUTDIR):
    # If the output directory does not exist yet, make it
    os.mkdir(OUTPUTDIR)

# Read the data
data = read_edf('default.asc', 'image_onset', \
    stop='image_offset')

# Get the amount of trials in this dataset
ntrials = len(data)

# Loop through all trials
for trialnr in range(ntrials):

    # Get the image name
    imgname = IMGNAMES[trialnr]

    # Get the path to the image
    imgpath = os.path.join(IMGDIR, imgname)

    # Get the fixations in this trial
    fixations = data[trialnr]['events']['Efix']

    # Delete the first fixation
    fixations.pop(0)

    # Get the raw x and y gaze coordinates
    x = data[trialnr]['x']
    y = data[trialnr]['y']

    # Plot the fixations
    savename = 'fixations_%s' % imgname
    savepath = os.path.join(OUTPUTDIR, savename)
    fig = gazeplotter.draw_fixations(fixations, DISPSIZE, \
        durationsize=True, durationcolour=False, \
        imagefile=imgpath, savefilename=savepath)
    close(fig)

   # Plot a heatmap
    savename = 'heatmap_%s' % imgname
    savepath = os.path.join(OUTPUTDIR, savename)
    fig = gazeplotter.draw_heatmap(fixations, DISPSIZE, \
        imagefile=imgpath, savefilename=savepath)
    close(fig)
