from constants import DISPSIZE
from psychopy.visual import Window, TextStim
from psychopy.event import waitKeys

# create a Window to show things on the monitor
disp = Window(size=DISPSIZE, units='pix', fullscr=True)

# define a super-important question
question = 'What do you think of this question?'

# define the question's position
qpos = (0, int(DISPSIZE[1]*0.2))
# create a new text stimulus
qstim = TextStim(disp, text=question, pos=qpos, height=24)
# draw the question
qstim.draw()
# create an additional text stimulus for the response
# (this will be updated later)
respstim = TextStim(disp, text='', height=24)

# start with an empty response string
response = ''
# start undone
done = False

# loop until done == False
while not done:

    # check for keypresses
    resplist = waitKeys(maxWait=float('inf'), keyList=None, \
        timeStamped=True)
    # use only the first in the returned list of keypresses
    key, presstime = resplist[0]

    # check if the length of the key's name equals 1
    if len(key) == 1:
        # add the key to the response
        response += key
    # check if the key is the Space bar
    elif key == 'space':
        # add a space to the response
        response += ' '
    # check if the key's name was 'backspace' and
    # check if the response has at least 1 character
    elif key == 'backspace' and len(response) > 0:
        # remove the last character of the response
        response = response[0:-1]
    # if the key was none of the above, check if it
    # was the Enter key
    if key == 'return':
        # set done to True
        done = True
    
    # update the response stimulus
    respstim.setText(response)

    # re-draw the question stimulus
    qstim.draw()
    # draw the response stimulus
    respstim.draw()
    # update the monitor
    disp.flip()

# close the Display
disp.close()