from pygaze.display import Display
from pygaze.screen import Screen
import pygaze.libtime as timer

# Initialise a new Display instance.
disp = Display()

# Create a new Screen instance.
fixscreen = Screen()
# Draw a fixation dot on the new Screen.
fixscreen.draw_fixation(fixtype='dot')

# Create another Screen instance.
imgscreen = Screen()
# Draw an image on this screen.
imgscreen.draw_image('example.png')

# Fill the Display with the fixation screen.
disp.fill(fixscreen)
# Show the Display on the computer monitor.
disp.show()
# Pause for one seconds.
timer.pause(1000)

# Fill the display with the image screen.
disp.fill(imgscreen)
# Show the Display on the computer monitor.
disp.show()
# Pause for two seconds.
timer.pause(2000)

# Close the Display again.
disp.close()