from constants import *
from pygaze.display import Display
from pygaze.screen import Screen
from pygaze.keyboard import Keyboard
import pygaze.libtime as timer

# create a Display to deal with the monitor
disp = Display()
# create a Keyboard to collect responses
kb = Keyboard(keylist=None, timeout=None)

# define the instructions
instructions = 'Welcome!\n\nIn this experiment, Es and Fs \
will appear on either side of the screen. If you see \
an E, press the E key. If you see an F, press F. \
\n\nPlease try to be as fast and as accurate as \
possible.\n\nGood luck!'
# create a new Screen
instscr = Screen()
# draw the instructions on the Screen
instscr.draw_text(text=instructions, fontsize=24)

# create a new Screen
fixscr = Screen()
# draw a fixation cross in the centre
fixscr.draw_fixation(fixtype='cross', diameter=12)

# draw the left box
fixscr.draw_rect(x=BOXCORS['left'][0], y=BOXCORS['left'][1], \
    w=BOXSIZE, h=BOXSIZE, pw=3, fill=False)
# draw the right box
fixscr.draw_rect(x=BOXCORS['right'][0], y=BOXCORS['right'][1], \
    w=BOXSIZE, h=BOXSIZE, pw=3, fill=False)

# create a dict with two new Screens for the cues
cuescr = {}
cuescr['left'] = Screen()
cuescr['right'] = Screen()
# copy the fixation Screen to both cue Screens
cuescr['left'].copy(fixscr)
cuescr['right'].copy(fixscr)
# draw the cue boxes with thicker penwidths
cuescr['left'].draw_rect(x=BOXCORS['left'][0], y=BOXCORS['left'][1], \
    w=BOXSIZE, h=BOXSIZE, pw=8, fill=False)
cuescr['right'].draw_rect(x=BOXCORS['right'][0], y=BOXCORS['right'][1], \
    w=BOXSIZE, h=BOXSIZE, pw=8, fill=False)

# create a dict to contain further dicts to contain target Screens
tarscr = {}
tarscr['left'] = {}
tarscr['left']['E'] = Screen()
tarscr['left']['F'] = Screen()
tarscr['right'] = {}
tarscr['right']['E'] = Screen()
tarscr['right']['F'] = Screen()
# copy the fixation Screen to each target Screen
tarscr['left']['E'].copy(fixscr)
tarscr['left']['F'].copy(fixscr)
tarscr['right']['E'].copy(fixscr)
tarscr['right']['F'].copy(fixscr)
# calculate the target positions
tarpos = {}
tarpos['left'] = (BOXCORS['left'][0] + BOXSIZE/2, \
    BOXCORS['left'][1] + BOXSIZE/2)
tarpos['right'] = (BOXCORS['right'][0] + BOXSIZE/2, \
    BOXCORS['right'][1] + BOXSIZE/2)
# draw all possible targets on the target Screens
tarscr['left']['E'].draw_text(text='E', pos=tarpos['left'], fontsize=48)
tarscr['left']['F'].draw_text(text='F', pos=tarpos['left'], fontsize=48)
tarscr['right']['E'].draw_text(text='E', pos=tarpos['right'], fontsize=48)
tarscr['right']['F'].draw_text(text='F', pos=tarpos['right'], fontsize=48)

# create two new feedback Screens in a dict
fbscr = {}
# draw the incorrect feedback (evil red letters!)
fbscr[0] = Screen()
fbscr[0].draw_text(text='Incorrect!', colour=(255,0,0), fontsize=24)
# draw the correct feedback (nice and green)
fbscr[1] = Screen()
fbscr[1].draw_text(text='Correct!', colour=(0,255,0), fontsize=24)

# present the instructions
disp.fill(instscr)
disp.show()
# wait for any old keypress
kb.get_key(keylist=None, timeout=None)

# show the fixation Screen
disp.fill(fixscr)
fixonset = disp.show()
# wait for a bit
timer.pause(FIXTIME)

# show a cue Screen
disp.fill(cuescr['left'])
cueonset = disp.show()
# wait for a little bit
timer.pause(CUETIME)

# show the fixation Screen again
disp.fill(fixscr)
cueoffset = disp.show()
# wait for the SOA minus the cue duration
timer.pause(100 - CUETIME)

# show a target Screen
disp.fill(tarscr['right']['E'])
taronset = disp.show()

# wait for a response
response, presstime = kb.get_key(keylist=['e', 'f'], timeout=None)
# turn the lowercase response into uppercase
response = response.upper()

# check if the response was correct
if response == 'E':
    correct = 1
else:
    correct = 0

# calculate the reaction time
RT = presstime - taronset

# show the appropriate feedback Screen
disp.fill(fbscr[correct])
disp.show()
# wait for a bit to allow the participant to see the feedback
timer.pause(FEEDBACKTIME)

# shut down the experiment
disp.close()