from constants import DISPSIZE
import numpy
from psychopy.visual import Window, GratingStim
from psychopy.core import wait

# Create a new Window instance.
disp = Window(size=DISPSIZE, units='pix', fullscr=True)

# Create a new grating stimulus.
gabor = GratingStim(disp, tex='sin', mask='gauss', sf=0.05, size=200)

# Create some noise using NumPy.
noise = (numpy.random.rand(64, 64) * 2) - 1
# Create a new grating stimulus, using the noise created before.
noisepatch = GratingStim(disp, tex=noise, mask='gauss', size=200)

# Draw the grating stimulus.
gabor.draw()
# Show the window on the computer monitor.
disp.flip()
# Wait for one second.
wait(1)

# Draw the noise stimulus.
noisepatch.draw()
# Show the window on the computer monitor.
disp.flip()
# Wait for two seconds.
wait(2)

disp.close()