from constants import DISPSIZE, FGC
from psychopy.visual import Window, Circle, ImageStim
from psychopy.core import wait

# Initialise a new Window instance.
disp = Window(size=DISPSIZE, units='pix', fullscr=True)

# Create a new circle stimulus.
# (This will serve as a fixation dot.)
fixmark = Circle(disp, radius=6, edges=64, \
    lineColor=FGC, fillColor=FGC)

# Create a new image stimulus
img = ImageStim(disp, image='example.png')

# Draw the circle stimulus.
fixmark.draw()
# Update the computer monitor.
disp.flip()
# Wait for one seconds.
wait(1)

# Draw the image.
img.draw()
# Update the computer monitor.
disp.flip()
# Wait for two seconds.
wait(2)

# Close the Display again.
disp.close()