import random
from constants import *
from psychopy.visual import Window, TextStim
from psychopy.event import waitKeys
from psychopy.sound import Sound

# create a new Display instance (to interact with the monitor)
disp = Window(size=DISPSIZE, units='pix', fullscr=True)

# create two Sounds: one for nice and one for stern feedback
high = Sound(value=4000, secs=0.5)
low = Sound(value=400, secs=0.5)

# a list of vowels
vowels = ['a', 'e', 'i', 'o', 'u', 'y']

# randomly choose one vowel
letter = random.choice(vowels)

# create a TextStim for the vowel
vowelstim = TextStim(disp, text=letter, height=128)

# draw the text stimulus
vowelstim.draw()
# update the monitor
disp.flip()

# wait for a response
resplist = waitKeys(maxWait=float('inf'), keyList=vowels, \
    timeStamped=True)
# select the first response from the list
key, presstime = resplist[0]

# check if the pressed key matches the displayed letter
if key == letter:
    correct = 1
else:
    correct = 0

# on a correct response...
if correct:
    # ...provide nice feedback
    feedback = 'Well done!'
    # (-1, 1, -1) is green
    fbcolour = (-1, 1, -1)
# on an incorrect response...
else:
    # ...provide nasty feedback
    feedback = 'You suck!'
    # (1, -1, -1) is red
    fbcolour = (1, -1, -1)

# construct an informative string by using variables
extrafb = 'The vowel was %s, and you typed %s.' \
    % (letter, key)

# create a stimulus for the feedback text
fbstim = TextStim(disp, text=feedback, color=fbcolour, \
    height=24)

# determine the position of the extra feedback
# (at half the screen width, and 60% of the screen height)
extrafbpos = (0, int(DISPSIZE[1]*-0.1))
# create a stimulus for the extra feedback
extrafbstim = TextStim(disp, text=extrafb, pos=extrafbpos, \
    height=24)

# show the feedback
fbstim.draw()
extrafbstim.draw()
disp.flip()

# on a correct response...
if correct:
    # ...play the high sine Sound
    high.play()
# on an incorrect response...
else:
    # ...play the low sine Sound
    low.play()

# wait for any keypress
waitKeys(maxWait=float('inf'), keyList=None)

# close the Display
disp.close()